FROM ubuntu
RUN apt update && apt upgrade -y

# timezone setup
RUN apt-get install tzdata -y
RUN ln -fs /usr/share/zoneinfo/Europe/Budapest /etc/localtime
# end of timezone setup

RUN apt install -y apache2 php8.1 php8.1-curl libapache2-mod-php8.1
RUN rm /etc/apache2/sites-enabled/000-default.conf
COPY ./myapp.conf /etc/apache2/sites-available/myapp.conf
RUN a2ensite myapp
COPY weboldal/ui.php /srv/myapp/index.php
COPY weboldal/ui_newproduct.php /srv/myapp/newproduct.php
RUN useradd webadmin
RUN chown webadmin /var/run/apache2 -R
RUN chown webadmin /var/log/apache2 -R
USER webadmin
EXPOSE 80/tcp
WORKDIR /srv/myapp
CMD apache2ctl -D FOREGROUND